
// Copyright (C) 2001 Evren Onur SOYKUT

//port adresi 7890
#include <ncurses.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>

char dongukir;
unsigned char *p1;
unsigned char tampon[136];
fd_set aktiffdset,anafdset; //fd setler
struct sockaddr_in sunucu;
struct sockaddr_in istemci;
int opt=1;
int sockfd,yenifd; //soket dosya islem numaralari
int adresuz;
int hata;
int sayac,sayac1,sayac2,sayac3;
int uzunluk,toplam,pboyu,sboyu,dboyu;
char kar,veri;
FILE *dosya;
struct
    {
    char adsoy[29];
    char telno[29];  //kayit veri alanlari
    char adres1[29];
    char adres2[44];
    }kayit;
main()
{

initscr();
nonl();
cbreak();    //once ncursesi yani ekrani bir hazirlayalim
noecho();
scrollok(stdscr,TRUE);//ekranin asagi kayabilmesine izin verilir

dosya=fopen("veritabani","r+"); //veri tabani dosyasi diskte varsa bu sekilde yoksa asagidaki sekilde acilir
if (dosya==NULL)
    {
    if(errno==ENOENT) dosya=fopen("veritabani","w+");	//Veritabanimizi acariz 
    else	
	{
	endwin();
	perror("hata");
	exit(1);
	}
    }	

FD_ZERO(&aktiffdset);
FD_ZERO(&anafdset);  //once setleri guzelce temizleyelim

sockfd = socket(AF_INET,SOCK_STREAM,0);
if (sockfd==-1)
    {
    endwin();           //socket acilir
    perror("socket");
    exit(1);
    }

hata=setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int));
if (hata==-1)
    {
    endwin();    //bu islem programdan ciktiktan ve tekrar girdikten sonra       
    perror("setsockopt"); //soket kullanimda hata mesajini almanizi engeller
    exit(1);
    }
sunucu.sin_family = AF_INET;  //socket adreslerimizi belirliyoruz
if(INADDR_ANY!=0) sunucu.sin_addr.s_addr = htonl(INADDR_ANY);// ip adresi kendi makinemizin adresidir
    else sunucu.sin_addr.s_addr = htonl(INADDR_LOOPBACK);//makinanin ip adresi yok ozaman loopback ayarla
sunucu.sin_port=htons(7890);
memset(&(sunucu.sin_zero),'\0',8);

hata=bind(sockfd,(struct sockaddr *)&sunucu,sizeof(sunucu));
if (hata==-1)  //socket bind ediliyor
    {
    endwin();
    perror("bind");
    exit(1);
    }
hata=listen(sockfd,10);
if (hata==-1) //socket gelecek baglantilar icin dinleme konumuna getiriliyor
    {         //10tane baglanti isteginin kuyrukta beklemesine izin veriliyor
    endwin();
    perror("listen");
    exit(1);
    }
addstr("Sunucu baslatilmistir.\n");
printw("Yerel IP adresi:%s:%hi\n",inet_ntoa(sunucu.sin_addr),ntohs(sunucu.sin_port));
addstr("Sunucuyu kapatmak icin q tusuna basiniz\n\n");
refresh();
/*bu noktadan sonra acilan socketler select komutuyla teker teker taranarak
bir istek varmi bakilacak.Bunun icin acilan socketlerin dosyaislem numaralari
setlerin icine aktarilir.Sunucu programin islemler esnasinda klavyeden gelecek
istekleride goz onune alabilmesi icin stdin dosya islem numarasida anafdset 
icine atilir.Fdset icindeki herhangi bir dosya islem numarasina veri gelmesi halinde
select komutu bir sonraki komuta devam eder ve okuma gerceklestirilir. Select komutundan once aktiffdsette
veri gelmismi diye arastirlacak dosya islem numaralari bulunur.Select komutundan ciktiktan sonra aktiffd set
icinde sadece veri gelmis olan dosya islem numarasi bulunur.Bu yuzden anafd setin degismemesi
icin anafd set aktiffdsetin icine yedeklenir ve islemler aktiffdset uzerinde yapilir. fd set degiskenleri
bit tipi degiskenlerdir.FDSET komutu bu bit degisken icinde pozisyonu dosya islem numarasiyla
ayni olan bit 1 yapar bu sekilde bu dosya islem numarasi aktif olur.*/
FD_SET(sockfd,&anafdset);//baglanti bekleyen socket dosyaislem numarasi
			    //anafdset icine atiliyor
FD_SET(STDIN_FILENO,&anafdset);//stdin anasete atiliyor
//iste ana dongu

do
    {			//select komutu fdseti degistirdiginden dolayi
    aktiffdset=anafdset;//anafdset akitfdsete yedeklenir
    hata=select(FD_SETSIZE,&aktiffdset,NULL,NULL,NULL);
    if(hata==-1)  //FD_SETSIZE maksimum dosya islem numarasidir
	{
	endwin();
        perror("select");
        exit(1);
	}		    
  //simdi tarama yaparak okumaya hazir bir dosya islem numarasi varmi bakilir
    for(sayac1=0;sayac1<FD_SETSIZE;sayac1++)
	{
	if(FD_ISSET(sayac1,&aktiffdset)) //hazir dosya islem numarasi vardir
	    {
	    if(sayac1==sockfd)
		{ //eger yerel dosya islem numarasi ise yeni 
		adresuz=sizeof(istemci); //baglanti gelmis demektir
		yenifd=accept(sockfd,(struct sockaddr *)&istemci,&adresuz);
		if (yenifd==-1)
		    {          
		    endwin();
		    perror("accept");
		    exit(1);
		    }
		FD_SET(yenifd,&anafdset);
		printw("%s:%hd adresinden baglanti kurulmustur\n",inet_ntoa(istemci.sin_addr),ntohs(istemci.sin_port));
		refresh();
		}
		
	    if(sayac1==STDIN_FILENO)//eger klavyeden bir sey yazilmissa bakilir
		{
		kar=getch();
		if (kar=='q' || kar=='Q') //kullanici q ya basti programdan cikilir
		    {
		    FD_CLR(STDIN_FILENO,&anafdset);//stdin setten cikarilir
		    for(sayac2=0;sayac2<FD_SETSIZE;sayac2++)
			{
			if(FD_ISSET(sayac2,&anafdset))
			    {
			    close(sayac2);//butun acik soketler kapatilir
			    }
			}
		    fclose(dosya);
		    clear();
		    mvaddstr(11,26,"Gene beklerim :)");
		    refresh();
		    endwin();
		    exit(0);
		    }
		}
		//diger durum okunacak bir seylerin gelmesidir.
	    if((sayac1!=sockfd)&&(sayac1!=STDIN_FILENO))
	        {
		dongukir=0;
		toplam=0;
		p1=tampon;
		do
		    {
		    uzunluk=recv(sayac1,p1,sizeof(tampon)-toplam,0);
		    refresh();     //paket alinir
		    switch(uzunluk)  
			{
			case -1:
			endwin();
    			perror("recv");
			exit(1);
			break;
		    
			case 0:  //karsi taraf baglantiyi kapatmistir
			close(sayac1);
    			FD_CLR(sayac1,&anafdset);
			printw("Baglanti kapatilmistir\n");
			dongukir=1; // dongusunu kirmak icin
			refresh();
			break;
		    
			default ://bu kisima gelinmisse sorun yoktur okuma gerceklestirilir
			switch(tampon[0])
			    {  //paketlerin uzunluklari belirlenir
			    case 1:   //yarim kalan paketlerin kalan kismi bu bilgiye gore cekilir
			    pboyu=132; //bilgi ekle paketi
			    break;
			    
			    case 2:
			    pboyu=30; //isim ile bilgi ara pakaketi
			    break;
			    
			    case 4:
			    pboyu=136; //bilgi duzeltme paketi 
			    break;
			    
			    case 6:
			    pboyu=5;// kayit no ile bilgi ara
			    break;
			    
			    default:
			    addstr("Gecersiz bir paket alinmistir...!\n");
			    refresh(); //bir sey yapma
			    uzunluk=0;
			    }
			}
		    toplam=toplam+uzunluk;
		    p1=p1+toplam;
		    if (dongukir==1) break;
		    }while(toplam < pboyu);	
		
		if(dongukir==0) //for dongusunu asagidaki switch islemeden bir artirir
		//cunku bu soket kapatilmistir asagidaki switchin islemesine gerek yoktur
		    {
		    fseek(dosya,0L,SEEK_END);
		    dboyu=ftell(dosya);//dosyanin uzunlugunu ogrenmek icin bir yontem
		    switch (tampon[0])
			{
			case 1:
			fseek(dosya,0L,SEEK_END); //dosyanin sonuna konumlanilir
			fwrite(tampon+1,131,1,dosya);//gelen 131 baytlik kayit dosyanin sonuna yazilir
			fflush(dosya); //hemen dosyamizi yazalim
			break;
		    
			case 2:
			memcpy(&kayit.adsoy,tampon+1,29);
			sboyu=strlen(kayit.adsoy);  //aratilacak isim alinir
			for(sayac3=0;sayac3<dboyu;sayac3=sayac3+131) //aratilacak isim dosyadaki kayitlarla teker teker karsilastirilir
			    {
			    fseek(dosya,sayac3,SEEK_SET);
			    fread(tampon+1,131,1,dosya);// dosya bastan sirayla okutulur
			    if(!strncasecmp(tampon+1,kayit.adsoy,sboyu))
		    		{
				tampon[0]=3;//cevap paketi hazirlanir once komut sonra kayit nosu pakete eklenir
				memcpy(tampon+132,&sayac3,4);
				toplam=0;
    				p1=tampon;
    				do
				    {
				    sayac=send(sayac1,p1,136-toplam,0);
				    if (sayac==-1)           // veriler gonderiliyor
					{
					clear();
					refresh();
					color_set(3,NULL);
					mvaddstr(12,20,"Veri gonderilemiyor....!");
    					refresh();         //hata durumu
    					endwin();
					exit(1);
					}
				    toplam=toplam+sayac;//veri parca parca giderse tamponda kalanlarda
				    p1=p1+toplam;  //gonderiliyor 
    				    } while(toplam < 136);
				break;
				}
			    }	    
			if (sayac3>=dboyu)
			    {
			    veri=5; //kayit bunamamistir bulunamadi paketi gonderilir
			    do
				{
				sayac=send(sayac1,&veri,1,0);
				if (sayac==-1)           // veri gonderiliyor
				    {
				    clear();
				    refresh();
				    color_set(3,NULL);
				    mvaddstr(12,20,"Veri gonderilemiyor....!");
    				    refresh();         //hata durumu
    				    endwin();
				    exit(1);
				    }			    			    
				}while(sayac==0); //veri gidene kadar tekrar gonder			
			    }
			break;
		    //kayit yok eklenmedi
			case 4:         //bilgi duzeltme paketi
			memcpy(&sayac3,tampon+132,4);
			fseek(dosya,sayac3,SEEK_SET); //kayit bulunur ve duzeltilir
			fwrite(tampon+1,131,1,dosya);
			fflush(dosya);
			break;
		    
			case 6:   //kayit no ile bilgi ara paketi
			memcpy(&sayac3,tampon+1,4);
			if (sayac3>=dboyu)
			    {
			    veri=5; //kayit bunamamistir bulunamadi paketi gonderilir
			    do
				{
				sayac=send(sayac1,&veri,1,0);
				if (sayac==-1)           // veri gonderiliyor
				    {
				    clear();
				    refresh();
				    color_set(3,NULL);
				    mvaddstr(12,20,"Veri gonderilemiyor....!");
    				    refresh();         //hata durumu
    				    endwin();
				    exit(1);
				    }			    			    
				}while(sayac==0); //veri gidene kadar tekrar gonder			
			    }
			else 
			    {
			    fseek(dosya,sayac3,SEEK_SET);
			    fread(tampon+1,131,1,dosya);// ilgili kayit dosyadan okutulur
			    memcpy(tampon+132,&sayac3,4);
			    tampon[0]=3;
			    toplam=0;
    			    p1=tampon;
    			    do
				{
				sayac=send(sayac1,p1,136-toplam,0);
				if (sayac==-1)           // veriler gonderiliyor
				    {
				    clear();
				    refresh();
				    color_set(3,NULL);
				    mvaddstr(12,20,"Veri gonderilemiyor....!");
    				    refresh();         //hata durumu
    				    endwin();
				    exit(1);
				    }
				toplam=toplam+sayac;//veri parca parca giderse tamponda kalanlarda
				p1=p1+toplam;  //gonderiliyor 
    				} while(toplam < 136);
			    }
			}		
		    } 
		}
	    }
	}    
    }while(1);
endwin();      //ncurses kapatiliyor bunu sakin unutmayin
}