
; Copyright (C) 2001 Evren Onur SOYKUT

;			kernel file
;                      we make initalizations
	org 0         
;                      ---------------------------
;we assign its initial value which is start of root directory to active directory sector variable
	mov word [adizsek],13 ;start of root directory is sector 13
;                      ---------------------------
	xor ax,ax
	mov es,ax
	mov dx,msekyuk ;we write adress of msekyuk subroutine to 20h th cell 
	mov [es:80h],dx   ;of interrupt vector table
	mov dx,1000h
	mov [es:82h],dx
;                      ---------------------------
	xor ax,ax
	mov es,ax
	mov dx,msekyaz ;we write adress of msekyuk subroutine to 21h th cell 
	mov [es:84h],dx   ;of interrupt vector table
	mov dx,1000h
	mov [es:86h],dx

;                      ---------------------------
;we search bin directory in the root directory.we put first sector of
;bin directory to variable yerbin
	mov ax,[adizsek]
	mov [deger2],ax  ;we bring active directory sector to deger2 variable
	xor dx,dx    
dongu11:
	mov ax,2000h
	mov es,ax   ;root directory is in adress 2000:0
	mov ax,[deger2] ;if it is longer than one sector we will continue to load
	mov bl,1
	int 20h
	
	xor di,di
dongu14:        
	mov bx,di ; we use bx as a spare of di 
	mov ax,2000h
	mov es,ax
	mov al, byte [es:di]
	cmp al,0     ;Files in the root directory has finished before finding bin directory
	je dongu12   ;system will halt

	mov si,sabit1
	mov cx,12     ;bin string is being compared
	rep cmpsb
	jne dongu15 
	
	mov di,bx
	add di,12   ;if length field is zero it means that we found bin directory
	mov ax, word [es:di]
	cmp ax,0
	jne dongu15 
	add di,2        
	mov ax,word [es:di]
	mov [yerbin],ax
	jmp dongu18

dongu15:        
	mov di,bx
	add di,16    ;we look whether we are at the end of one sector or not
	cmp di,512   
	jne dongu14  
		     

	mov ax,[deger2] 
	shl ax,1         ;(sektor*2)/512 is used to understand which sektor of 
	xor dx,dx        ;file system table is necessary
	mov bx,512    
	div bx           ;division is sektor number where necessary file system table exists
	inc ax           ;remainder is offset in this file system table
	push dx 	;with this offset we can reach the cell of used sector 
	push ax
	
	mov ax,3000h 
	mov es,ax  ;file system table is being loaded
	pop ax
	xor dx,dx
	mov bl,1
	int 20h
	
	mov ax,3000h
	mov es,ax
	pop bx   ;we look whether file system table cell that we interested in is eof or not
	mov ax,word [es:bx]
	cmp ax,1
	je dongu12
	mov [deger2],ax  ; if it isnt eof we load subsequent sector
	jmp dongu11   
dongu12:
	mov bp,sabit2  ;if it is eof that means root directory doesnt contain bin directory 
	call str_yaz  ;we print error message
dongu13:
	jmp dongu13  ;sistem will halt
dongu18:
;                      ---------------------------
        mov ax,900h   ;kernel makes a dta(data transfer area) at memory adress 900:0 
	mov es,ax     ;to communicate with programs
	mov bx,0

	mov [es:bx],word 3e2fh ;we assign /> as a initial value to command line string field in the dta 
	mov [es:2+bx],byte 0  

	mov ax,word [adizsek]
	mov [es:66+bx],ax

	mov [es:68+bx],word dongu3

	mov ah,1
	mov cx,0607h ;cursor on
	int 10h

;                      ---------------------------
;                      ---------------------------
	   
;                      Main loop of kernel file
;                      ---------------------------
;                      ---------------------------
;we take commands from user and put it to string variable komut
;and then we cut komut variable into two pieces, one of them is program name part
;saved in kprog variable and the other part is parameter saved in param variable
dongu3:    ;return point from programs to the kernel

	mov bx,0
	mov cx,12
dongu282:
	mov byte [bx+kprog],byte 32 ;at first we fill kprog variable with white spaces
	inc bx
	loop dongu282

	mov ax,900h
	mov es,ax
	
	mov bx,0
dongu28:                ;we find length of command line string field in dta 
	mov al,[es:bx]  
	inc bx
	cmp al,0
	jne dongu28
	
	mov cx,bx
	mov ax,1000h
	mov es,ax
	mov ax,900h
	mov ds,ax
        mov si,0     ;we copy command line string field in dta 
	mov di,dizin ;to the variable dizin
	rep movsb

	mov ax,900h
	mov es,ax     ;we restore segment registers
	mov ax,1000h
	mov ds,ax

	mov ax,word [es:66]
	mov [adizsek],ax   ;we bring active directory sector to adizsek variable from dta
;                      ---------------------------
	mov bp,dizin
	call str_yaz
;                      ---------------------------
	mov byte [deger1],byte 0  ;we use deger1 as a character index 
dongu1:                  ;here we take command string from user
	mov ah,10h
	int 16h          
		    ;we control characters
	cmp al,31   
	jg karal
	cmp al,8
	je bspace    ;user press backspace
	cmp al,13
	je etus     ;user press enter
	cmp al,0    ;user press a key which produces two character
	je ikikar
	jmp dongu1
karal:      ;karakteri alir
	cmp [deger1],byte 79
	je dongu1 ;if user enter maximum character amount do nothing

	push ax    
	mov al,[deger1]
	cbw      
	mov bx,ax  

	pop ax   
	mov [bx+komut],al  ;we add entered characters to string variable komut
	mov ah,0eh  ;and at the same time we echo this string to screen so that user
	xor bh,bh  ;can see what he or she typed
	int 10h
	inc byte [deger1] ;deger1 is an charater index and indicates length of entered string 
	jmp dongu1        ;because it keeps position of character that user last typed
bspace:               ;user entered backspace 
	cmp [deger1],byte 0
	je dongu1
	mov ah,3     ;we take cursor position
	mov bh,0
	int 10h
       
	dec dl
	push dx   ;we take the cursor one character back
	mov ah,2
	mov bh,0
	int 10h
	
	mov ax,0e20h
	xor bh,bh     ;we print white space
	int 10h       
	
	pop dx
	mov ah,2
	mov bh,0    ;and again we take cursor one character back
	int 10h     ;all these actions makes the function of backspace

	dec byte [deger1]   ;we decrease character index
	jmp dongu1
ikikar:                 ;user press a key which produces two character
	mov ah,11h
	int 16h  ; we look if there is a character after ascii 0 in the buffer
	jz dongu1
	
	mov ah,10h
	int 16h     ;we flush buffer 
	jmp dongu1
etus:           ;user press enter
	mov al,[deger1]
	cbw        
	mov bx,ax
	mov [bx+komut],byte 0  ;we put terminating character ascii 0  to the end of string variable komut 
	
	mov ax,0e0dh  ;at the same time we make carriage return
	xor bh,bh  
	int 10h
	
	mov ax,0e0ah
	xor bh,bh  
	int 10h  
;                      ----------------
	mov ax,1000h
	mov es,ax
	mov si,komut    ;we divide komut into two pieces here
	mov di,kprog
dongu4:                             
	cmp [si],byte 32
	jne dongu981  ;we deletes the white spaces that user entered before 
	inc si     ;program name
	jmp dongu4
dongu981:
	cmp [si],byte 0 ;use just typed a space character do nothing
	jne dongu5 
	jmp dongu3
dongu5:
	mov al,[si]  ;we transfer program part of komut variable to kprog variable 
	mov byte [di],al  
	inc si       
	inc di       

	cmp byte [si], byte 0 ;we control here whether user entered any parameter
	jne dongu50

	mov bx,di
dongu106:
	sub di,kprog
	cmp di,11
	jg dongu105
	mov [bx],byte 32  ;we add spaces at the end of kprog
	inc di		  
	inc bx		  
	jmp dongu106

dongu105:                        
	mov [param] ,byte 0 ;user entered no parameter so we terminated param variable by zero
	jmp dongu51
dongu50:
	cmp byte [si],byte 32
	jne dongu5

	mov bx,di
dongu107:
	sub di,kprog
	cmp di,11
	jg dongu108
	mov [bx],byte 32  
	inc di
	inc bx
	jmp dongu107
dongu108:

			  
	mov di,param
dongu6:
	inc si
	cmp [si],byte 32 ;we take the white spaces that user entered before parameter
	je dongu6
	dec si
	dec di
dongu7:
	inc si
	inc di
	mov al,[si]
	mov [di],al ;we transfer parameter part of komut variable to param variable 
		    
	cmp [si],byte 0    
	jne dongu7


        cmp di,param
        je dongu51    ;if there is no parameter pass the following block

dongu120:
	dec di           ;we take the white spaces that user entered after parameter
	cmp [di],byte 32
	je dongu120      ;we add terminating ascii zero character at the end of param variable
	inc di
	mov [di], byte 0

dongu51:
	mov bx,param    ;we transfer parameter to dta 
	mov di,70 
dongu29:        
	mov ax,900h
	mov es,ax
	mov al,[bx]
	mov [es:di],al
	inc bx
	inc di
	cmp [bx-1],byte 0
	jne dongu29
	      
;                      ---------------------------
        mov ax,1000h
        mov es,ax
        mov ds,ax
        mov cx,12
	mov di,kprog
	mov si,sabit5
	rep cmpsb      ;we prevent user from executing .. file 
	jne dongu200   
	mov bp,sabit6
	call str_yaz
	jmp dongu3
dongu200:
;                      ---------------------------
;we search program name in bin directory if we cant find it we search it in
;active directory
	
	mov ax,word [yerbin]        
	mov [deger2],ax  ;we copy first sector of bin directory to deger2 variable
	xor dx,dx    ;directory is being loaded to adress [2000:0] 
dongu31:
	mov ax,2000h
	mov es,ax   
	mov ax,word [deger2] ;if it is longer than one sector we will continue to load
	mov bl,1        
	int 20h
	
	xor di,di
dongu34:        
	mov ax,2000h
	mov es,ax
	mov al, byte [es:di]
	cmp al,0     ;Files in the active directory has finished before a match   
	je dongu38   

	mov dx,di      
	mov cx,12
	mov si,kprog      ;kprog string is being compared
	rep cmpsb 
	jne dongu35
       
	mov di,dx   
        add di,12

        mov ax,word [es:di]
        cmp ax,0    ;we prevent user from executing a directory
        je  dongu35   

        add di,2  ;we copy first sector of program to variable yerprog
	mov ax,word [es:di]  ;we found program in bin directory
	mov [yerprog],ax
	jmp dongu21
dongu35:        
	mov di,dx   
	add di,16    ;we look whether we are at the end of the sector or not
	cmp di,512
	jne dongu34

	mov ax,word [deger2]
	shl ax,1        ;(sektor*2)/512 is used to understand which sektor of 
	xor dx,dx            ;file system table is necessary
	mov bx,512
	div bx
	inc ax
	push dx
	push ax
	
	mov ax,3000h 
	mov es,ax  ;file system table is being loaded
	pop ax
	xor dx,dx
	mov bl,1
	int 20h
	
	mov ax,3000h
	mov es,ax
	pop bx   ;we look whether file system table cell that we interested in is eof or not
	mov ax,word [es:bx]
	cmp ax,1
	je dongu38
	mov [deger2],ax  ; if it isnt eof we load subsequent sector
	jmp dongu31   

dongu38:
;                      ---------------------------
;we search program name in active directory. Active directory is the directory where the user is in       
	mov ax,word [adizsek]
	mov [deger2],ax  ;we copy first sector of active directory to deger2 variable
	xor dx,dx    
dongu41:
	mov ax,2000h
	mov es,ax   ;directory is being loaded to adress [2000:0] 
	mov ax,word [deger2] 
	mov bl,1       ;if it is longer than one sector we will continue to load
	int 20h
	
	xor di,di
dongu44:        
	mov ax,2000h
	mov es,ax
	mov al, byte [es:di]
	cmp al,0     ;Files in the active directory has finished before a match   
	je dongu42   

	mov dx,di
	mov cx,12
	mov si,kprog     ;kprog string is being compared
	rep cmpsb         ;di ye mudahele olmamalidir
	jne dongu45
 
        mov di,dx     
        add di,12     
        mov ax,word [es:di]
        cmp ax,0    ;we prevent user from executing a directory
        je  dongu45   
   
        add di,2             
	mov ax,word [es:di]  
	mov [yerprog],ax     ;we found program at active directory
	jmp dongu21

dongu45:        
	mov di,dx
	add di,16    ;we look whether we are at the end of the sector or not
	cmp di,512   
	jne dongu44  

	mov ax,word [deger2]  
	shl ax,1         ;(sektor*2)/512 is used to understand which sektor of 
	xor dx,dx        ;file system table is necessary
	mov bx,512
	div bx
	inc ax
	push dx
	push ax
	
	mov ax,3000h 
	mov es,ax  ;file system table is being loaded
	pop ax
	xor dx,dx
	mov bl,1
	int 20h
	
	mov ax,3000h
	mov es,ax
	pop bx   ;we look whether file system table cell that we interested in is eof or not
	mov ax,word [es:bx]
	cmp ax,1
	je dongu42
	mov [deger2],ax  ; if it isnt eof we load subsequent sector
	jmp dongu41   

dongu42:
	mov bp,sabit3  
	call str_yaz   ;we print sabit3
	jmp dongu3

;                      ---------------------------
dongu21:      ;yerprog is ready now. yerprog variable indicates first sector of program that will be loaded
	mov ax,word [yerprog]
	mov [deger2],ax
	xor dx,dx
dongu49:
	push dx   
	mov ax,2000h
	mov es,ax   ;program is being loaded at adress 2000:0 
	mov ax,word [deger2] ;if it is longer than one sector we will continue to load
	mov bl,1        
	int 20h     ;dx keeps the offset adress during loading process
	
	mov ax,word [deger2]
	shl ax,1         ;(sektor*2)/512 is used to understand which sektor of 
	xor dx,dx           ;file system table is necessary
	mov bx,512
	div bx
	inc ax
	push dx
	push ax
	
	mov ax,3000h 
	mov es,ax      ;file system table is being loaded
	pop ax
	xor dx,dx
	mov bl,1
	int 20h
	
	mov ax,3000h
	mov es,ax
	pop bx   ;we look whether file system table cell that we interested in is eof or not
	mov ax,word [es:bx]
	cmp ax,1
	je dongu39
	mov [deger2],ax  ; if it isnt eof we load subsequent sector
	pop dx     
	add dx,512
	jmp dongu49   
dongu39:
	mov ax,2000h
	mov es,ax
	mov ds,ax   ;we transfer control to loaded program 
	mov ss,ax
        mov sp,0ffffh  ;we prepare segment registers
	jmp 2000h:0
;                      ---------------------------
;                      ---------------------------




;                      Subroutines
;                      ---------------------------
;                      ---------------------------
msekyuk:
;sector loading subroutine
;ax (0-2879) sektor number, bl indicates how many sectors will be read (1-128), es:dx
;buffer adress 
;this subroutine reads sectors from diskette driver.it takes lineer sector numbers (0-2879)
;from programmer and convert it to head,cylinder and physical sector numbers
;that hardware can understand. it uses BIOS interrupts
        push ds         ;subroutine uses it own data segment 
        push ax         ;but stack segment adress of subroutine is callers 
        mov ax,1000h    ;stack segment
	mov ds,ax
	pop ax

	mov byte [deger3],3 ;we try to read three times

	push bx ;we protect callers some registers
	push si ;
	push di

	mov word [deger11],ax  ;we save some registers
	mov word [deger12],bx  
	mov word [deger13],dx  
dongu152:                     
	mov ax,word [deger11]
	mov bx,word [deger12]
	mov dx,word [deger13]

	push dx 
	push ax

	mov ah,0
	xor dl,dl ;fdc reset
	int 13h

	pop ax
	mov bh,18
	div bh      ;lineer sector number is divided by 18 (sector number in a track)
	inc ah
	mov cl,ah   ;remainder is physical sector number and division is divided by 2 (total heads)
	cbw         ;Division is cylinder number and remainder is head number
	mov bh,2   
	div bh
	mov ch,al  ;sector(1-18), cylinder (0-79), head(0-1)
	mov dh,ah
	mov al,bl  
	pop bx  ;we transfer buffer adress to bx 
	xor dl,dl 
	mov ah,2  
	dec byte [deger3]
	int 13h
	cmp ah,0
	je dongu154
	cmp byte [deger3],0
	jne dongu152

	mov bp,sabit4  ;we couldnt read diskette 
	call str_yaz
dongu154:
	pop di
	pop si
	pop bx
	pop ds
	iret
;                      ---------------------------
msekyaz:
;sector writing subroutine
;ax (0-2879) sektor number, bl indicates how many sectors will be read (1-128), es:dx
;buffer adress 

;this subroutine writes sectors to diskette driver.it takes lineer sector numbers (0-2879)
;from programmer and convert it to head,cylinder and physical sector numbers
;that hardware can understand. it uses BIOS interrupts
        push ds        ;subroutine uses it own data segment
        push ax        ;but stack segment adress of subroutine is callers 
        mov ax,1000h   ;stack segment
	mov ds,ax
	pop ax

	mov byte [deger3],3 ;we try to write three times

	push bx ;we protect callers some registers
	push si 
	push di

	mov word [deger11],ax  
	mov word [deger12],bx  
	mov word [deger13],dx  
dongu352:                     
	mov ax,word [deger11]
	mov bx,word [deger12]
	mov dx,word [deger13]

	push dx
	push ax

	mov ah,0
	xor dl,dl ;fdc reset
	int 13h

	pop ax
	mov bh,18
	div bh      ;lineer sector number is divided by 18 (sector number in a track)
	inc ah
	mov cl,ah   ;remainder is physical sector number and division is divided by 2 (total heads)
	cbw         ;Division is cylinder number and remainder is head number
	mov bh,2   
	div bh
	mov ch,al  ;sector(1-18), cylinder (0-79), head(0-1)
	mov dh,ah
	mov al,bl  
	pop bx  	;we transfer buffer adress to bx 
	xor dl,dl 
	mov ah,3  
	dec byte [deger3]
	int 13h

	cmp ah,0
	je dongu354
	cmp byte [deger3],0
	jne dongu352

	mov bp,sabit4  ;we couldnt write to diskette 
	call str_yaz
dongu354:
	pop di
	pop si
	pop bx
	pop ds
	iret
;                      ---------------------------
str_yaz:
;this subroutine prints zero teminated string
;bp is string adress
	mov bx,bp   
	dec bx     
dongu69:
	inc bx
	cmp byte [bx],0
	jne dongu69
	sub bx,bp

	push bp
	push bx 

	mov ah,3
	xor bh,bh   ;we take cursor position
	int 10h

	pop cx  ;cx here keeps string length 
	pop bp
	mov ax,ds
	mov es,ax
	mov ax,1301h  
	mov bx,7     ;we print message
	int 10h
	ret
;                      ---------------------------
;                      ---------------------------




;                      Veriables
;                      ---------------------------
;                      ---------------------------
	adizsek resb 2
	dizin resb 66
	komut resb 80
	deger1 resb 1  
	deger2 resb 2
	deger3 resb 1
	deger11 resb 2
	deger12 resb 2
	deger13 resb 2
	kprog resb 12  ;this string is constant length so there is no need to terminating character
	param resb 80
	yerbin resb 2
	sektor resb 1
	yerprog resb 2
        sabit1 db 'bin         '
        sabit2 db 'Bin directory doesnt exist.System halted....!',0dh,0ah,0
	sabit3 db 'Invalid command or program name....!',0dh,0ah,0
	sabit4 db 'Read error....!',0dh,0ah,0
	sabit5 db '..          '
	sabit6 db '.. file is not an executable file...!',0dh,0ah,0

